require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_LINUX_VIRTIO_PCI_H)) {
    eval 'sub _LINUX_VIRTIO_PCI_H () {1;}' unless defined(&_LINUX_VIRTIO_PCI_H);
    require 'linux/types.ph';
    require 'linux/kernel.ph';
    unless(defined(&VIRTIO_PCI_NO_LEGACY)) {
	eval 'sub VIRTIO_PCI_HOST_FEATURES () {0;}' unless defined(&VIRTIO_PCI_HOST_FEATURES);
	eval 'sub VIRTIO_PCI_GUEST_FEATURES () {4;}' unless defined(&VIRTIO_PCI_GUEST_FEATURES);
	eval 'sub VIRTIO_PCI_QUEUE_PFN () {8;}' unless defined(&VIRTIO_PCI_QUEUE_PFN);
	eval 'sub VIRTIO_PCI_QUEUE_NUM () {12;}' unless defined(&VIRTIO_PCI_QUEUE_NUM);
	eval 'sub VIRTIO_PCI_QUEUE_SEL () {14;}' unless defined(&VIRTIO_PCI_QUEUE_SEL);
	eval 'sub VIRTIO_PCI_QUEUE_NOTIFY () {16;}' unless defined(&VIRTIO_PCI_QUEUE_NOTIFY);
	eval 'sub VIRTIO_PCI_STATUS () {18;}' unless defined(&VIRTIO_PCI_STATUS);
	eval 'sub VIRTIO_PCI_ISR () {19;}' unless defined(&VIRTIO_PCI_ISR);
	eval 'sub VIRTIO_MSI_CONFIG_VECTOR () {20;}' unless defined(&VIRTIO_MSI_CONFIG_VECTOR);
	eval 'sub VIRTIO_MSI_QUEUE_VECTOR () {22;}' unless defined(&VIRTIO_MSI_QUEUE_VECTOR);
	eval 'sub VIRTIO_PCI_CONFIG_OFF {
	    my($msix_enabled) = @_;
    	    eval q((($msix_enabled) ? 24: 20));
	}' unless defined(&VIRTIO_PCI_CONFIG_OFF);
	eval 'sub VIRTIO_PCI_CONFIG {
	    my($dev) = @_;
    	    eval q( &VIRTIO_PCI_CONFIG_OFF(($dev)-> &msix_enabled));
	}' unless defined(&VIRTIO_PCI_CONFIG);
	eval 'sub VIRTIO_PCI_ABI_VERSION () {0;}' unless defined(&VIRTIO_PCI_ABI_VERSION);
	eval 'sub VIRTIO_PCI_QUEUE_ADDR_SHIFT () {12;}' unless defined(&VIRTIO_PCI_QUEUE_ADDR_SHIFT);
	eval 'sub VIRTIO_PCI_VRING_ALIGN () {4096;}' unless defined(&VIRTIO_PCI_VRING_ALIGN);
    }
    eval 'sub VIRTIO_PCI_ISR_CONFIG () {0x2;}' unless defined(&VIRTIO_PCI_ISR_CONFIG);
    eval 'sub VIRTIO_MSI_NO_VECTOR () {0xffff;}' unless defined(&VIRTIO_MSI_NO_VECTOR);
    unless(defined(&VIRTIO_PCI_NO_MODERN)) {
	eval 'sub VIRTIO_PCI_CAP_COMMON_CFG () {1;}' unless defined(&VIRTIO_PCI_CAP_COMMON_CFG);
	eval 'sub VIRTIO_PCI_CAP_NOTIFY_CFG () {2;}' unless defined(&VIRTIO_PCI_CAP_NOTIFY_CFG);
	eval 'sub VIRTIO_PCI_CAP_ISR_CFG () {3;}' unless defined(&VIRTIO_PCI_CAP_ISR_CFG);
	eval 'sub VIRTIO_PCI_CAP_DEVICE_CFG () {4;}' unless defined(&VIRTIO_PCI_CAP_DEVICE_CFG);
	eval 'sub VIRTIO_PCI_CAP_PCI_CFG () {5;}' unless defined(&VIRTIO_PCI_CAP_PCI_CFG);
	eval 'sub VIRTIO_PCI_CAP_SHARED_MEMORY_CFG () {8;}' unless defined(&VIRTIO_PCI_CAP_SHARED_MEMORY_CFG);
	eval 'sub VIRTIO_PCI_CAP_VENDOR_CFG () {9;}' unless defined(&VIRTIO_PCI_CAP_VENDOR_CFG);
	eval 'sub VIRTIO_PCI_CAP_VNDR () {0;}' unless defined(&VIRTIO_PCI_CAP_VNDR);
	eval 'sub VIRTIO_PCI_CAP_NEXT () {1;}' unless defined(&VIRTIO_PCI_CAP_NEXT);
	eval 'sub VIRTIO_PCI_CAP_LEN () {2;}' unless defined(&VIRTIO_PCI_CAP_LEN);
	eval 'sub VIRTIO_PCI_CAP_CFG_TYPE () {3;}' unless defined(&VIRTIO_PCI_CAP_CFG_TYPE);
	eval 'sub VIRTIO_PCI_CAP_BAR () {4;}' unless defined(&VIRTIO_PCI_CAP_BAR);
	eval 'sub VIRTIO_PCI_CAP_OFFSET () {8;}' unless defined(&VIRTIO_PCI_CAP_OFFSET);
	eval 'sub VIRTIO_PCI_CAP_LENGTH () {12;}' unless defined(&VIRTIO_PCI_CAP_LENGTH);
	eval 'sub VIRTIO_PCI_NOTIFY_CAP_MULT () {16;}' unless defined(&VIRTIO_PCI_NOTIFY_CAP_MULT);
	eval 'sub VIRTIO_PCI_COMMON_DFSELECT () {0;}' unless defined(&VIRTIO_PCI_COMMON_DFSELECT);
	eval 'sub VIRTIO_PCI_COMMON_DF () {4;}' unless defined(&VIRTIO_PCI_COMMON_DF);
	eval 'sub VIRTIO_PCI_COMMON_GFSELECT () {8;}' unless defined(&VIRTIO_PCI_COMMON_GFSELECT);
	eval 'sub VIRTIO_PCI_COMMON_GF () {12;}' unless defined(&VIRTIO_PCI_COMMON_GF);
	eval 'sub VIRTIO_PCI_COMMON_MSIX () {16;}' unless defined(&VIRTIO_PCI_COMMON_MSIX);
	eval 'sub VIRTIO_PCI_COMMON_NUMQ () {18;}' unless defined(&VIRTIO_PCI_COMMON_NUMQ);
	eval 'sub VIRTIO_PCI_COMMON_STATUS () {20;}' unless defined(&VIRTIO_PCI_COMMON_STATUS);
	eval 'sub VIRTIO_PCI_COMMON_CFGGENERATION () {21;}' unless defined(&VIRTIO_PCI_COMMON_CFGGENERATION);
	eval 'sub VIRTIO_PCI_COMMON_Q_SELECT () {22;}' unless defined(&VIRTIO_PCI_COMMON_Q_SELECT);
	eval 'sub VIRTIO_PCI_COMMON_Q_SIZE () {24;}' unless defined(&VIRTIO_PCI_COMMON_Q_SIZE);
	eval 'sub VIRTIO_PCI_COMMON_Q_MSIX () {26;}' unless defined(&VIRTIO_PCI_COMMON_Q_MSIX);
	eval 'sub VIRTIO_PCI_COMMON_Q_ENABLE () {28;}' unless defined(&VIRTIO_PCI_COMMON_Q_ENABLE);
	eval 'sub VIRTIO_PCI_COMMON_Q_NOFF () {30;}' unless defined(&VIRTIO_PCI_COMMON_Q_NOFF);
	eval 'sub VIRTIO_PCI_COMMON_Q_DESCLO () {32;}' unless defined(&VIRTIO_PCI_COMMON_Q_DESCLO);
	eval 'sub VIRTIO_PCI_COMMON_Q_DESCHI () {36;}' unless defined(&VIRTIO_PCI_COMMON_Q_DESCHI);
	eval 'sub VIRTIO_PCI_COMMON_Q_AVAILLO () {40;}' unless defined(&VIRTIO_PCI_COMMON_Q_AVAILLO);
	eval 'sub VIRTIO_PCI_COMMON_Q_AVAILHI () {44;}' unless defined(&VIRTIO_PCI_COMMON_Q_AVAILHI);
	eval 'sub VIRTIO_PCI_COMMON_Q_USEDLO () {48;}' unless defined(&VIRTIO_PCI_COMMON_Q_USEDLO);
	eval 'sub VIRTIO_PCI_COMMON_Q_USEDHI () {52;}' unless defined(&VIRTIO_PCI_COMMON_Q_USEDHI);
	eval 'sub VIRTIO_PCI_COMMON_Q_NDATA () {56;}' unless defined(&VIRTIO_PCI_COMMON_Q_NDATA);
	eval 'sub VIRTIO_PCI_COMMON_Q_RESET () {58;}' unless defined(&VIRTIO_PCI_COMMON_Q_RESET);
	eval 'sub VIRTIO_PCI_COMMON_ADM_Q_IDX () {60;}' unless defined(&VIRTIO_PCI_COMMON_ADM_Q_IDX);
	eval 'sub VIRTIO_PCI_COMMON_ADM_Q_NUM () {62;}' unless defined(&VIRTIO_PCI_COMMON_ADM_Q_NUM);
    }
    eval 'sub VIRTIO_ADMIN_STATUS_OK () {0;}' unless defined(&VIRTIO_ADMIN_STATUS_OK);
    eval 'sub VIRTIO_ADMIN_CMD_LIST_QUERY () {0x;}' unless defined(&VIRTIO_ADMIN_CMD_LIST_QUERY);
    eval 'sub VIRTIO_ADMIN_CMD_LIST_USE () {0x1;}' unless defined(&VIRTIO_ADMIN_CMD_LIST_USE);
    eval 'sub VIRTIO_ADMIN_GROUP_TYPE_SELF () {0x;}' unless defined(&VIRTIO_ADMIN_GROUP_TYPE_SELF);
    eval 'sub VIRTIO_ADMIN_GROUP_TYPE_SRIOV () {0x1;}' unless defined(&VIRTIO_ADMIN_GROUP_TYPE_SRIOV);
    eval 'sub VIRTIO_ADMIN_CMD_LEGACY_COMMON_CFG_WRITE () {0x2;}' unless defined(&VIRTIO_ADMIN_CMD_LEGACY_COMMON_CFG_WRITE);
    eval 'sub VIRTIO_ADMIN_CMD_LEGACY_COMMON_CFG_READ () {0x3;}' unless defined(&VIRTIO_ADMIN_CMD_LEGACY_COMMON_CFG_READ);
    eval 'sub VIRTIO_ADMIN_CMD_LEGACY_DEV_CFG_WRITE () {0x4;}' unless defined(&VIRTIO_ADMIN_CMD_LEGACY_DEV_CFG_WRITE);
    eval 'sub VIRTIO_ADMIN_CMD_LEGACY_DEV_CFG_READ () {0x5;}' unless defined(&VIRTIO_ADMIN_CMD_LEGACY_DEV_CFG_READ);
    eval 'sub VIRTIO_ADMIN_CMD_LEGACY_NOTIFY_INFO () {0x6;}' unless defined(&VIRTIO_ADMIN_CMD_LEGACY_NOTIFY_INFO);
    eval 'sub VIRTIO_ADMIN_CMD_CAP_ID_LIST_QUERY () {0x7;}' unless defined(&VIRTIO_ADMIN_CMD_CAP_ID_LIST_QUERY);
    eval 'sub VIRTIO_ADMIN_CMD_DEVICE_CAP_GET () {0x8;}' unless defined(&VIRTIO_ADMIN_CMD_DEVICE_CAP_GET);
    eval 'sub VIRTIO_ADMIN_CMD_DRIVER_CAP_SET () {0x9;}' unless defined(&VIRTIO_ADMIN_CMD_DRIVER_CAP_SET);
    eval 'sub VIRTIO_ADMIN_CMD_RESOURCE_OBJ_CREATE () {0xa;}' unless defined(&VIRTIO_ADMIN_CMD_RESOURCE_OBJ_CREATE);
    eval 'sub VIRTIO_ADMIN_CMD_RESOURCE_OBJ_DESTROY () {0xd;}' unless defined(&VIRTIO_ADMIN_CMD_RESOURCE_OBJ_DESTROY);
    eval 'sub VIRTIO_ADMIN_CMD_DEV_PARTS_METADATA_GET () {0xe;}' unless defined(&VIRTIO_ADMIN_CMD_DEV_PARTS_METADATA_GET);
    eval 'sub VIRTIO_ADMIN_CMD_DEV_PARTS_GET () {0xf;}' unless defined(&VIRTIO_ADMIN_CMD_DEV_PARTS_GET);
    eval 'sub VIRTIO_ADMIN_CMD_DEV_PARTS_SET () {0x10;}' unless defined(&VIRTIO_ADMIN_CMD_DEV_PARTS_SET);
    eval 'sub VIRTIO_ADMIN_CMD_DEV_MODE_SET () {0x11;}' unless defined(&VIRTIO_ADMIN_CMD_DEV_MODE_SET);
    eval 'sub VIRTIO_ADMIN_CMD_NOTIFY_INFO_FLAGS_END () {0;}' unless defined(&VIRTIO_ADMIN_CMD_NOTIFY_INFO_FLAGS_END);
    eval 'sub VIRTIO_ADMIN_CMD_NOTIFY_INFO_FLAGS_OWNER_DEV () {0x1;}' unless defined(&VIRTIO_ADMIN_CMD_NOTIFY_INFO_FLAGS_OWNER_DEV);
    eval 'sub VIRTIO_ADMIN_CMD_NOTIFY_INFO_FLAGS_OWNER_MEM () {0x2;}' unless defined(&VIRTIO_ADMIN_CMD_NOTIFY_INFO_FLAGS_OWNER_MEM);
    eval 'sub VIRTIO_ADMIN_CMD_MAX_NOTIFY_INFO () {4;}' unless defined(&VIRTIO_ADMIN_CMD_MAX_NOTIFY_INFO);
    eval 'sub VIRTIO_DEV_PARTS_CAP () {0x;}' unless defined(&VIRTIO_DEV_PARTS_CAP);
    eval 'sub MAX_CAP_ID () { &__KERNEL_DIV_ROUND_UP( &VIRTIO_DEV_PARTS_CAP + 1, 64);}' unless defined(&MAX_CAP_ID);
    eval 'sub VIRTIO_RESOURCE_OBJ_DEV_PARTS () {0;}' unless defined(&VIRTIO_RESOURCE_OBJ_DEV_PARTS);
    eval 'sub VIRTIO_RESOURCE_OBJ_DEV_PARTS_TYPE_GET () {0;}' unless defined(&VIRTIO_RESOURCE_OBJ_DEV_PARTS_TYPE_GET);
    eval 'sub VIRTIO_RESOURCE_OBJ_DEV_PARTS_TYPE_SET () {1;}' unless defined(&VIRTIO_RESOURCE_OBJ_DEV_PARTS_TYPE_SET);
    eval 'sub VIRTIO_ADMIN_CMD_DEV_PARTS_METADATA_TYPE_SIZE () {0;}' unless defined(&VIRTIO_ADMIN_CMD_DEV_PARTS_METADATA_TYPE_SIZE);
    eval 'sub VIRTIO_ADMIN_CMD_DEV_PARTS_METADATA_TYPE_COUNT () {1;}' unless defined(&VIRTIO_ADMIN_CMD_DEV_PARTS_METADATA_TYPE_COUNT);
    eval 'sub VIRTIO_ADMIN_CMD_DEV_PARTS_METADATA_TYPE_LIST () {2;}' unless defined(&VIRTIO_ADMIN_CMD_DEV_PARTS_METADATA_TYPE_LIST);
    eval 'sub VIRTIO_DEV_PART_F_OPTIONAL () {0;}' unless defined(&VIRTIO_DEV_PART_F_OPTIONAL);
    eval 'sub VIRTIO_ADMIN_CMD_DEV_PARTS_GET_TYPE_SELECTED () {0;}' unless defined(&VIRTIO_ADMIN_CMD_DEV_PARTS_GET_TYPE_SELECTED);
    eval 'sub VIRTIO_ADMIN_CMD_DEV_PARTS_GET_TYPE_ALL () {1;}' unless defined(&VIRTIO_ADMIN_CMD_DEV_PARTS_GET_TYPE_ALL);
    eval 'sub VIRTIO_ADMIN_CMD_DEV_MODE_F_STOPPED () {0;}' unless defined(&VIRTIO_ADMIN_CMD_DEV_MODE_F_STOPPED);
}
1;
