require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__LINUX_KVM_POWERPC_H)) {
    eval 'sub __LINUX_KVM_POWERPC_H () {1;}' unless defined(&__LINUX_KVM_POWERPC_H);
    require 'linux/types.ph';
    eval 'sub __KVM_HAVE_SPAPR_TCE () {1;}' unless defined(&__KVM_HAVE_SPAPR_TCE);
    eval 'sub __KVM_HAVE_PPC_SMT () {1;}' unless defined(&__KVM_HAVE_PPC_SMT);
    eval 'sub __KVM_HAVE_IRQCHIP () {1;}' unless defined(&__KVM_HAVE_IRQCHIP);
    eval 'sub __KVM_HAVE_IRQ_LINE () {1;}' unless defined(&__KVM_HAVE_IRQ_LINE);
    eval 'sub KVM_COALESCED_MMIO_PAGE_OFFSET () {1;}' unless defined(&KVM_COALESCED_MMIO_PAGE_OFFSET);
    eval 'sub KVM_SREGS_E_IMPL_NONE () {0;}' unless defined(&KVM_SREGS_E_IMPL_NONE);
    eval 'sub KVM_SREGS_E_IMPL_FSL () {1;}' unless defined(&KVM_SREGS_E_IMPL_FSL);
    eval 'sub KVM_SREGS_E_FSL_PIDn () {(1<< 0);}' unless defined(&KVM_SREGS_E_FSL_PIDn);
    eval 'sub KVM_RUN_PPC_NMI_DISP_MASK () {(3<< 0);}' unless defined(&KVM_RUN_PPC_NMI_DISP_MASK);
    eval 'sub KVM_RUN_PPC_NMI_DISP_FULLY_RECOV () {(1<< 0);}' unless defined(&KVM_RUN_PPC_NMI_DISP_FULLY_RECOV);
    eval 'sub KVM_RUN_PPC_NMI_DISP_LIMITED_RECOV () {(2<< 0);}' unless defined(&KVM_RUN_PPC_NMI_DISP_LIMITED_RECOV);
    eval 'sub KVM_RUN_PPC_NMI_DISP_NOT_RECOV () {(3<< 0);}' unless defined(&KVM_RUN_PPC_NMI_DISP_NOT_RECOV);
    eval 'sub KVM_SREGS_E_BASE () {(1<< 0);}' unless defined(&KVM_SREGS_E_BASE);
    eval 'sub KVM_SREGS_E_ARCH206 () {(1<< 1);}' unless defined(&KVM_SREGS_E_ARCH206);
    eval 'sub KVM_SREGS_E_64 () {(1<< 2);}' unless defined(&KVM_SREGS_E_64);
    eval 'sub KVM_SREGS_E_SPRG8 () {(1<< 3);}' unless defined(&KVM_SREGS_E_SPRG8);
    eval 'sub KVM_SREGS_E_MCIVPR () {(1<< 4);}' unless defined(&KVM_SREGS_E_MCIVPR);
    eval 'sub KVM_SREGS_E_IVOR () {(1<< 5);}' unless defined(&KVM_SREGS_E_IVOR);
    eval 'sub KVM_SREGS_E_ARCH206_MMU () {(1<< 6);}' unless defined(&KVM_SREGS_E_ARCH206_MMU);
    eval 'sub KVM_SREGS_E_DEBUG () {(1<< 7);}' unless defined(&KVM_SREGS_E_DEBUG);
    eval 'sub KVM_SREGS_E_ED () {(1<< 8);}' unless defined(&KVM_SREGS_E_ED);
    eval 'sub KVM_SREGS_E_SPE () {(1<< 9);}' unless defined(&KVM_SREGS_E_SPE);
    eval 'sub KVM_SREGS_EXP () {(1<< 10);}' unless defined(&KVM_SREGS_EXP);
    eval 'sub KVM_SREGS_E_PD () {(1<< 11);}' unless defined(&KVM_SREGS_E_PD);
    eval 'sub KVM_SREGS_E_PC () {(1<< 12);}' unless defined(&KVM_SREGS_E_PC);
    eval 'sub KVM_SREGS_E_PT () {(1<< 13);}' unless defined(&KVM_SREGS_E_PT);
    eval 'sub KVM_SREGS_E_PM () {(1<< 14);}' unless defined(&KVM_SREGS_E_PM);
    eval 'sub KVM_SREGS_E_UPDATE_MCSR () {(1<< 0);}' unless defined(&KVM_SREGS_E_UPDATE_MCSR);
    eval 'sub KVM_SREGS_E_UPDATE_TSR () {(1<< 1);}' unless defined(&KVM_SREGS_E_UPDATE_TSR);
    eval 'sub KVM_SREGS_E_UPDATE_DEC () {(1<< 2);}' unless defined(&KVM_SREGS_E_UPDATE_DEC);
    eval 'sub KVM_SREGS_E_UPDATE_DBSR () {(1<< 3);}' unless defined(&KVM_SREGS_E_UPDATE_DBSR);
    eval 'sub KVMPPC_DEBUG_NONE () {0x;}' unless defined(&KVMPPC_DEBUG_NONE);
    eval 'sub KVMPPC_DEBUG_BREAKPOINT () {(1 << 1);}' unless defined(&KVMPPC_DEBUG_BREAKPOINT);
    eval 'sub KVMPPC_DEBUG_WATCH_WRITE () {(1 << 2);}' unless defined(&KVMPPC_DEBUG_WATCH_WRITE);
    eval 'sub KVMPPC_DEBUG_WATCH_READ () {(1 << 3);}' unless defined(&KVMPPC_DEBUG_WATCH_READ);
    eval 'sub KVM_GUESTDBG_USE_SW_BP () {0x10000;}' unless defined(&KVM_GUESTDBG_USE_SW_BP);
    eval 'sub KVM_GUESTDBG_USE_HW_BP () {0x20000;}' unless defined(&KVM_GUESTDBG_USE_HW_BP);
    eval 'sub KVM_INTERRUPT_SET () {-1;}' unless defined(&KVM_INTERRUPT_SET);
    eval 'sub KVM_INTERRUPT_UNSET () {-2;}' unless defined(&KVM_INTERRUPT_UNSET);
    eval 'sub KVM_INTERRUPT_SET_LEVEL () {-3;}' unless defined(&KVM_INTERRUPT_SET_LEVEL);
    eval 'sub KVM_CPU_440 () {1;}' unless defined(&KVM_CPU_440);
    eval 'sub KVM_CPU_E500V2 () {2;}' unless defined(&KVM_CPU_E500V2);
    eval 'sub KVM_CPU_3S_32 () {3;}' unless defined(&KVM_CPU_3S_32);
    eval 'sub KVM_CPU_3S_64 () {4;}' unless defined(&KVM_CPU_3S_64);
    eval 'sub KVM_CPU_E500MC () {5;}' unless defined(&KVM_CPU_E500MC);
    eval 'sub KVM_GET_HTAB_BOLTED_ONLY () {(( &__u64)0x1);}' unless defined(&KVM_GET_HTAB_BOLTED_ONLY);
    eval 'sub KVM_GET_HTAB_WRITE () {(( &__u64)0x2);}' unless defined(&KVM_GET_HTAB_WRITE);
    eval 'sub KVM_PPC_MMUV3_RADIX () {1;}' unless defined(&KVM_PPC_MMUV3_RADIX);
    eval 'sub KVM_PPC_MMUV3_GTSE () {2;}' unless defined(&KVM_PPC_MMUV3_GTSE);
    eval 'sub KVM_PPC_CPU_CHAR_SPEC_BAR_ORI31 () {(1 << 63);}' unless defined(&KVM_PPC_CPU_CHAR_SPEC_BAR_ORI31);
    eval 'sub KVM_PPC_CPU_CHAR_BCCTRL_SERIALISED () {(1 << 62);}' unless defined(&KVM_PPC_CPU_CHAR_BCCTRL_SERIALISED);
    eval 'sub KVM_PPC_CPU_CHAR_L1D_FLUSH_ORI30 () {(1 << 61);}' unless defined(&KVM_PPC_CPU_CHAR_L1D_FLUSH_ORI30);
    eval 'sub KVM_PPC_CPU_CHAR_L1D_FLUSH_TRIG2 () {(1 << 60);}' unless defined(&KVM_PPC_CPU_CHAR_L1D_FLUSH_TRIG2);
    eval 'sub KVM_PPC_CPU_CHAR_L1D_THREAD_PRIV () {(1 << 59);}' unless defined(&KVM_PPC_CPU_CHAR_L1D_THREAD_PRIV);
    eval 'sub KVM_PPC_CPU_CHAR_BR_HINT_HONOURED () {(1 << 58);}' unless defined(&KVM_PPC_CPU_CHAR_BR_HINT_HONOURED);
    eval 'sub KVM_PPC_CPU_CHAR_MTTRIG_THR_RECONF () {(1 << 57);}' unless defined(&KVM_PPC_CPU_CHAR_MTTRIG_THR_RECONF);
    eval 'sub KVM_PPC_CPU_CHAR_COUNT_CACHE_DIS () {(1 << 56);}' unless defined(&KVM_PPC_CPU_CHAR_COUNT_CACHE_DIS);
    eval 'sub KVM_PPC_CPU_CHAR_BCCTR_FLUSH_ASSIST () {(1 << 54);}' unless defined(&KVM_PPC_CPU_CHAR_BCCTR_FLUSH_ASSIST);
    eval 'sub KVM_PPC_CPU_BEHAV_FAVOUR_SECURITY () {(1 << 63);}' unless defined(&KVM_PPC_CPU_BEHAV_FAVOUR_SECURITY);
    eval 'sub KVM_PPC_CPU_BEHAV_L1D_FLUSH_PR () {(1 << 62);}' unless defined(&KVM_PPC_CPU_BEHAV_L1D_FLUSH_PR);
    eval 'sub KVM_PPC_CPU_BEHAV_BNDS_CHK_SPEC_BAR () {(1 << 61);}' unless defined(&KVM_PPC_CPU_BEHAV_BNDS_CHK_SPEC_BAR);
    eval 'sub KVM_PPC_CPU_BEHAV_FLUSH_COUNT_CACHE () {(1 << 58);}' unless defined(&KVM_PPC_CPU_BEHAV_FLUSH_COUNT_CACHE);
    eval 'sub KVM_REG_PPC_ICP_STATE () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x8c);}' unless defined(&KVM_REG_PPC_ICP_STATE);
    eval 'sub KVM_REG_PPC_ICP_CPPR_SHIFT () {56;}' unless defined(&KVM_REG_PPC_ICP_CPPR_SHIFT);
    eval 'sub KVM_REG_PPC_ICP_CPPR_MASK () {0xff;}' unless defined(&KVM_REG_PPC_ICP_CPPR_MASK);
    eval 'sub KVM_REG_PPC_ICP_XISR_SHIFT () {32;}' unless defined(&KVM_REG_PPC_ICP_XISR_SHIFT);
    eval 'sub KVM_REG_PPC_ICP_XISR_MASK () {0xffffff;}' unless defined(&KVM_REG_PPC_ICP_XISR_MASK);
    eval 'sub KVM_REG_PPC_ICP_MFRR_SHIFT () {24;}' unless defined(&KVM_REG_PPC_ICP_MFRR_SHIFT);
    eval 'sub KVM_REG_PPC_ICP_MFRR_MASK () {0xff;}' unless defined(&KVM_REG_PPC_ICP_MFRR_MASK);
    eval 'sub KVM_REG_PPC_ICP_PPRI_SHIFT () {16;}' unless defined(&KVM_REG_PPC_ICP_PPRI_SHIFT);
    eval 'sub KVM_REG_PPC_ICP_PPRI_MASK () {0xff;}' unless defined(&KVM_REG_PPC_ICP_PPRI_MASK);
    eval 'sub KVM_REG_PPC_VP_STATE () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U128 | 0x8d);}' unless defined(&KVM_REG_PPC_VP_STATE);
    eval 'sub KVM_DEV_MPIC_GRP_MISC () {1;}' unless defined(&KVM_DEV_MPIC_GRP_MISC);
    eval 'sub KVM_DEV_MPIC_BASE_ADDR () {0;}' unless defined(&KVM_DEV_MPIC_BASE_ADDR);
    eval 'sub KVM_DEV_MPIC_GRP_REGISTER () {2;}' unless defined(&KVM_DEV_MPIC_GRP_REGISTER);
    eval 'sub KVM_DEV_MPIC_GRP_IRQ_ACTIVE () {3;}' unless defined(&KVM_DEV_MPIC_GRP_IRQ_ACTIVE);
    eval 'sub KVM_REG_PPC_HIOR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x1);}' unless defined(&KVM_REG_PPC_HIOR);
    eval 'sub KVM_REG_PPC_IAC1 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x2);}' unless defined(&KVM_REG_PPC_IAC1);
    eval 'sub KVM_REG_PPC_IAC2 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x3);}' unless defined(&KVM_REG_PPC_IAC2);
    eval 'sub KVM_REG_PPC_IAC3 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x4);}' unless defined(&KVM_REG_PPC_IAC3);
    eval 'sub KVM_REG_PPC_IAC4 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x5);}' unless defined(&KVM_REG_PPC_IAC4);
    eval 'sub KVM_REG_PPC_DAC1 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x6);}' unless defined(&KVM_REG_PPC_DAC1);
    eval 'sub KVM_REG_PPC_DAC2 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x7);}' unless defined(&KVM_REG_PPC_DAC2);
    eval 'sub KVM_REG_PPC_DABR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x8);}' unless defined(&KVM_REG_PPC_DABR);
    eval 'sub KVM_REG_PPC_DSCR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x9);}' unless defined(&KVM_REG_PPC_DSCR);
    eval 'sub KVM_REG_PPC_PURR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xa);}' unless defined(&KVM_REG_PPC_PURR);
    eval 'sub KVM_REG_PPC_SPURR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xb);}' unless defined(&KVM_REG_PPC_SPURR);
    eval 'sub KVM_REG_PPC_DAR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xc);}' unless defined(&KVM_REG_PPC_DAR);
    eval 'sub KVM_REG_PPC_DSISR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0xd);}' unless defined(&KVM_REG_PPC_DSISR);
    eval 'sub KVM_REG_PPC_AMR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xe);}' unless defined(&KVM_REG_PPC_AMR);
    eval 'sub KVM_REG_PPC_UAMOR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xf);}' unless defined(&KVM_REG_PPC_UAMOR);
    eval 'sub KVM_REG_PPC_MMCR0 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x10);}' unless defined(&KVM_REG_PPC_MMCR0);
    eval 'sub KVM_REG_PPC_MMCR1 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x11);}' unless defined(&KVM_REG_PPC_MMCR1);
    eval 'sub KVM_REG_PPC_MMCRA () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x12);}' unless defined(&KVM_REG_PPC_MMCRA);
    eval 'sub KVM_REG_PPC_MMCR2 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x13);}' unless defined(&KVM_REG_PPC_MMCR2);
    eval 'sub KVM_REG_PPC_MMCRS () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x14);}' unless defined(&KVM_REG_PPC_MMCRS);
    eval 'sub KVM_REG_PPC_SIAR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x15);}' unless defined(&KVM_REG_PPC_SIAR);
    eval 'sub KVM_REG_PPC_SDAR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x16);}' unless defined(&KVM_REG_PPC_SDAR);
    eval 'sub KVM_REG_PPC_SIER () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x17);}' unless defined(&KVM_REG_PPC_SIER);
    eval 'sub KVM_REG_PPC_PMC1 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x18);}' unless defined(&KVM_REG_PPC_PMC1);
    eval 'sub KVM_REG_PPC_PMC2 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x19);}' unless defined(&KVM_REG_PPC_PMC2);
    eval 'sub KVM_REG_PPC_PMC3 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x1a);}' unless defined(&KVM_REG_PPC_PMC3);
    eval 'sub KVM_REG_PPC_PMC4 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x1b);}' unless defined(&KVM_REG_PPC_PMC4);
    eval 'sub KVM_REG_PPC_PMC5 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x1c);}' unless defined(&KVM_REG_PPC_PMC5);
    eval 'sub KVM_REG_PPC_PMC6 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x1d);}' unless defined(&KVM_REG_PPC_PMC6);
    eval 'sub KVM_REG_PPC_PMC7 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x1e);}' unless defined(&KVM_REG_PPC_PMC7);
    eval 'sub KVM_REG_PPC_PMC8 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x1f);}' unless defined(&KVM_REG_PPC_PMC8);
    eval 'sub KVM_REG_PPC_FPR0 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x20);}' unless defined(&KVM_REG_PPC_FPR0);
    eval 'sub KVM_REG_PPC_FPR {
        my($n) = @_;
	    eval q(( &KVM_REG_PPC_FPR0 + ($n)));
    }' unless defined(&KVM_REG_PPC_FPR);
    eval 'sub KVM_REG_PPC_FPR31 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x3f);}' unless defined(&KVM_REG_PPC_FPR31);
    eval 'sub KVM_REG_PPC_VR0 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U128 | 0x40);}' unless defined(&KVM_REG_PPC_VR0);
    eval 'sub KVM_REG_PPC_VR {
        my($n) = @_;
	    eval q(( &KVM_REG_PPC_VR0 + ($n)));
    }' unless defined(&KVM_REG_PPC_VR);
    eval 'sub KVM_REG_PPC_VR31 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U128 | 0x5f);}' unless defined(&KVM_REG_PPC_VR31);
    eval 'sub KVM_REG_PPC_VSR0 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U128 | 0x60);}' unless defined(&KVM_REG_PPC_VSR0);
    eval 'sub KVM_REG_PPC_VSR {
        my($n) = @_;
	    eval q(( &KVM_REG_PPC_VSR0 + ($n)));
    }' unless defined(&KVM_REG_PPC_VSR);
    eval 'sub KVM_REG_PPC_VSR31 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U128 | 0x7f);}' unless defined(&KVM_REG_PPC_VSR31);
    eval 'sub KVM_REG_PPC_FPSCR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x80);}' unless defined(&KVM_REG_PPC_FPSCR);
    eval 'sub KVM_REG_PPC_VSCR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x81);}' unless defined(&KVM_REG_PPC_VSCR);
    eval 'sub KVM_REG_PPC_VPA_ADDR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x82);}' unless defined(&KVM_REG_PPC_VPA_ADDR);
    eval 'sub KVM_REG_PPC_VPA_SLB () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U128 | 0x83);}' unless defined(&KVM_REG_PPC_VPA_SLB);
    eval 'sub KVM_REG_PPC_VPA_DTL () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U128 | 0x84);}' unless defined(&KVM_REG_PPC_VPA_DTL);
    eval 'sub KVM_REG_PPC_EPCR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x85);}' unless defined(&KVM_REG_PPC_EPCR);
    eval 'sub KVM_REG_PPC_EPR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x86);}' unless defined(&KVM_REG_PPC_EPR);
    eval 'sub KVM_REG_PPC_OR_TSR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x87);}' unless defined(&KVM_REG_PPC_OR_TSR);
    eval 'sub KVM_REG_PPC_CLEAR_TSR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x88);}' unless defined(&KVM_REG_PPC_CLEAR_TSR);
    eval 'sub KVM_REG_PPC_TCR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x89);}' unless defined(&KVM_REG_PPC_TCR);
    eval 'sub KVM_REG_PPC_TSR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x8a);}' unless defined(&KVM_REG_PPC_TSR);
    eval 'sub KVM_REG_PPC_DEBUG_INST () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x8b);}' unless defined(&KVM_REG_PPC_DEBUG_INST);
    eval 'sub KVM_REG_PPC_MAS0 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x8c);}' unless defined(&KVM_REG_PPC_MAS0);
    eval 'sub KVM_REG_PPC_MAS1 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x8d);}' unless defined(&KVM_REG_PPC_MAS1);
    eval 'sub KVM_REG_PPC_MAS2 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x8e);}' unless defined(&KVM_REG_PPC_MAS2);
    eval 'sub KVM_REG_PPC_MAS7_3 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x8f);}' unless defined(&KVM_REG_PPC_MAS7_3);
    eval 'sub KVM_REG_PPC_MAS4 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x90);}' unless defined(&KVM_REG_PPC_MAS4);
    eval 'sub KVM_REG_PPC_MAS6 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x91);}' unless defined(&KVM_REG_PPC_MAS6);
    eval 'sub KVM_REG_PPC_MMUCFG () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x92);}' unless defined(&KVM_REG_PPC_MMUCFG);
    eval 'sub KVM_REG_PPC_TLB0CFG () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x93);}' unless defined(&KVM_REG_PPC_TLB0CFG);
    eval 'sub KVM_REG_PPC_TLB1CFG () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x94);}' unless defined(&KVM_REG_PPC_TLB1CFG);
    eval 'sub KVM_REG_PPC_TLB2CFG () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x95);}' unless defined(&KVM_REG_PPC_TLB2CFG);
    eval 'sub KVM_REG_PPC_TLB3CFG () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x96);}' unless defined(&KVM_REG_PPC_TLB3CFG);
    eval 'sub KVM_REG_PPC_TLB0PS () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x97);}' unless defined(&KVM_REG_PPC_TLB0PS);
    eval 'sub KVM_REG_PPC_TLB1PS () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x98);}' unless defined(&KVM_REG_PPC_TLB1PS);
    eval 'sub KVM_REG_PPC_TLB2PS () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x99);}' unless defined(&KVM_REG_PPC_TLB2PS);
    eval 'sub KVM_REG_PPC_TLB3PS () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x9a);}' unless defined(&KVM_REG_PPC_TLB3PS);
    eval 'sub KVM_REG_PPC_EPTCFG () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x9b);}' unless defined(&KVM_REG_PPC_EPTCFG);
    eval 'sub KVM_REG_PPC_TB_OFFSET () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x9c);}' unless defined(&KVM_REG_PPC_TB_OFFSET);
    eval 'sub KVM_REG_PPC_SPMC1 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x9d);}' unless defined(&KVM_REG_PPC_SPMC1);
    eval 'sub KVM_REG_PPC_SPMC2 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0x9e);}' unless defined(&KVM_REG_PPC_SPMC2);
    eval 'sub KVM_REG_PPC_IAMR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0x9f);}' unless defined(&KVM_REG_PPC_IAMR);
    eval 'sub KVM_REG_PPC_TFHAR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xa0);}' unless defined(&KVM_REG_PPC_TFHAR);
    eval 'sub KVM_REG_PPC_TFIAR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xa1);}' unless defined(&KVM_REG_PPC_TFIAR);
    eval 'sub KVM_REG_PPC_TEXASR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xa2);}' unless defined(&KVM_REG_PPC_TEXASR);
    eval 'sub KVM_REG_PPC_FSCR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xa3);}' unless defined(&KVM_REG_PPC_FSCR);
    eval 'sub KVM_REG_PPC_PSPB () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0xa4);}' unless defined(&KVM_REG_PPC_PSPB);
    eval 'sub KVM_REG_PPC_EBBHR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xa5);}' unless defined(&KVM_REG_PPC_EBBHR);
    eval 'sub KVM_REG_PPC_EBBRR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xa6);}' unless defined(&KVM_REG_PPC_EBBRR);
    eval 'sub KVM_REG_PPC_BESCR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xa7);}' unless defined(&KVM_REG_PPC_BESCR);
    eval 'sub KVM_REG_PPC_TAR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xa8);}' unless defined(&KVM_REG_PPC_TAR);
    eval 'sub KVM_REG_PPC_DPDES () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xa9);}' unless defined(&KVM_REG_PPC_DPDES);
    eval 'sub KVM_REG_PPC_DAWR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xaa);}' unless defined(&KVM_REG_PPC_DAWR);
    eval 'sub KVM_REG_PPC_DAWRX () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xab);}' unless defined(&KVM_REG_PPC_DAWRX);
    eval 'sub KVM_REG_PPC_CIABR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xac);}' unless defined(&KVM_REG_PPC_CIABR);
    eval 'sub KVM_REG_PPC_IC () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xad);}' unless defined(&KVM_REG_PPC_IC);
    eval 'sub KVM_REG_PPC_VTB () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xae);}' unless defined(&KVM_REG_PPC_VTB);
    eval 'sub KVM_REG_PPC_CSIGR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xaf);}' unless defined(&KVM_REG_PPC_CSIGR);
    eval 'sub KVM_REG_PPC_TACR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xb0);}' unless defined(&KVM_REG_PPC_TACR);
    eval 'sub KVM_REG_PPC_TCSCR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xb1);}' unless defined(&KVM_REG_PPC_TCSCR);
    eval 'sub KVM_REG_PPC_PID () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xb2);}' unless defined(&KVM_REG_PPC_PID);
    eval 'sub KVM_REG_PPC_ACOP () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xb3);}' unless defined(&KVM_REG_PPC_ACOP);
    eval 'sub KVM_REG_PPC_VRSAVE () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0xb4);}' unless defined(&KVM_REG_PPC_VRSAVE);
    eval 'sub KVM_REG_PPC_LPCR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0xb5);}' unless defined(&KVM_REG_PPC_LPCR);
    eval 'sub KVM_REG_PPC_LPCR_64 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xb5);}' unless defined(&KVM_REG_PPC_LPCR_64);
    eval 'sub KVM_REG_PPC_PPR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xb6);}' unless defined(&KVM_REG_PPC_PPR);
    eval 'sub KVM_REG_PPC_ARCH_COMPAT () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0xb7);}' unless defined(&KVM_REG_PPC_ARCH_COMPAT);
    eval 'sub KVM_REG_PPC_DABRX () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0xb8);}' unless defined(&KVM_REG_PPC_DABRX);
    eval 'sub KVM_REG_PPC_WORT () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xb9);}' unless defined(&KVM_REG_PPC_WORT);
    eval 'sub KVM_REG_PPC_SPRG9 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xba);}' unless defined(&KVM_REG_PPC_SPRG9);
    eval 'sub KVM_REG_PPC_DBSR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0xbb);}' unless defined(&KVM_REG_PPC_DBSR);
    eval 'sub KVM_REG_PPC_TIDR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xbc);}' unless defined(&KVM_REG_PPC_TIDR);
    eval 'sub KVM_REG_PPC_PSSCR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xbd);}' unless defined(&KVM_REG_PPC_PSSCR);
    eval 'sub KVM_REG_PPC_DEC_EXPIRY () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xbe);}' unless defined(&KVM_REG_PPC_DEC_EXPIRY);
    eval 'sub KVM_REG_PPC_ONLINE () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U32 | 0xbf);}' unless defined(&KVM_REG_PPC_ONLINE);
    eval 'sub KVM_REG_PPC_PTCR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xc0);}' unless defined(&KVM_REG_PPC_PTCR);
    eval 'sub KVM_REG_PPC_MMCR3 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xc1);}' unless defined(&KVM_REG_PPC_MMCR3);
    eval 'sub KVM_REG_PPC_SIER2 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xc2);}' unless defined(&KVM_REG_PPC_SIER2);
    eval 'sub KVM_REG_PPC_SIER3 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xc3);}' unless defined(&KVM_REG_PPC_SIER3);
    eval 'sub KVM_REG_PPC_DAWR1 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xc4);}' unless defined(&KVM_REG_PPC_DAWR1);
    eval 'sub KVM_REG_PPC_DAWRX1 () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xc5);}' unless defined(&KVM_REG_PPC_DAWRX1);
    eval 'sub KVM_REG_PPC_DEXCR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xc6);}' unless defined(&KVM_REG_PPC_DEXCR);
    eval 'sub KVM_REG_PPC_HASHKEYR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xc7);}' unless defined(&KVM_REG_PPC_HASHKEYR);
    eval 'sub KVM_REG_PPC_HASHPKEYR () {( &KVM_REG_PPC |  &KVM_REG_SIZE_U64 | 0xc8);}' unless defined(&KVM_REG_PPC_HASHPKEYR);
    eval 'sub KVM_REG_PPC_TM () {( &KVM_REG_PPC | 0x80000000);}' unless defined(&KVM_REG_PPC_TM);
    eval 'sub KVM_REG_PPC_TM_GPR0 () {( &KVM_REG_PPC_TM |  &KVM_REG_SIZE_U64 | 0);}' unless defined(&KVM_REG_PPC_TM_GPR0);
    eval 'sub KVM_REG_PPC_TM_GPR {
        my($n) = @_;
	    eval q(( &KVM_REG_PPC_TM_GPR0 + ($n)));
    }' unless defined(&KVM_REG_PPC_TM_GPR);
    eval 'sub KVM_REG_PPC_TM_GPR31 () {( &KVM_REG_PPC_TM |  &KVM_REG_SIZE_U64 | 0x1f);}' unless defined(&KVM_REG_PPC_TM_GPR31);
    eval 'sub KVM_REG_PPC_TM_VSR0 () {( &KVM_REG_PPC_TM |  &KVM_REG_SIZE_U128 | 0x20);}' unless defined(&KVM_REG_PPC_TM_VSR0);
    eval 'sub KVM_REG_PPC_TM_VSR {
        my($n) = @_;
	    eval q(( &KVM_REG_PPC_TM_VSR0 + ($n)));
    }' unless defined(&KVM_REG_PPC_TM_VSR);
    eval 'sub KVM_REG_PPC_TM_VSR63 () {( &KVM_REG_PPC_TM |  &KVM_REG_SIZE_U128 | 0x5f);}' unless defined(&KVM_REG_PPC_TM_VSR63);
    eval 'sub KVM_REG_PPC_TM_CR () {( &KVM_REG_PPC_TM |  &KVM_REG_SIZE_U64 | 0x60);}' unless defined(&KVM_REG_PPC_TM_CR);
    eval 'sub KVM_REG_PPC_TM_LR () {( &KVM_REG_PPC_TM |  &KVM_REG_SIZE_U64 | 0x61);}' unless defined(&KVM_REG_PPC_TM_LR);
    eval 'sub KVM_REG_PPC_TM_CTR () {( &KVM_REG_PPC_TM |  &KVM_REG_SIZE_U64 | 0x62);}' unless defined(&KVM_REG_PPC_TM_CTR);
    eval 'sub KVM_REG_PPC_TM_FPSCR () {( &KVM_REG_PPC_TM |  &KVM_REG_SIZE_U64 | 0x63);}' unless defined(&KVM_REG_PPC_TM_FPSCR);
    eval 'sub KVM_REG_PPC_TM_AMR () {( &KVM_REG_PPC_TM |  &KVM_REG_SIZE_U64 | 0x64);}' unless defined(&KVM_REG_PPC_TM_AMR);
    eval 'sub KVM_REG_PPC_TM_PPR () {( &KVM_REG_PPC_TM |  &KVM_REG_SIZE_U64 | 0x65);}' unless defined(&KVM_REG_PPC_TM_PPR);
    eval 'sub KVM_REG_PPC_TM_VRSAVE () {( &KVM_REG_PPC_TM |  &KVM_REG_SIZE_U64 | 0x66);}' unless defined(&KVM_REG_PPC_TM_VRSAVE);
    eval 'sub KVM_REG_PPC_TM_VSCR () {( &KVM_REG_PPC_TM |  &KVM_REG_SIZE_U32 | 0x67);}' unless defined(&KVM_REG_PPC_TM_VSCR);
    eval 'sub KVM_REG_PPC_TM_DSCR () {( &KVM_REG_PPC_TM |  &KVM_REG_SIZE_U64 | 0x68);}' unless defined(&KVM_REG_PPC_TM_DSCR);
    eval 'sub KVM_REG_PPC_TM_TAR () {( &KVM_REG_PPC_TM |  &KVM_REG_SIZE_U64 | 0x69);}' unless defined(&KVM_REG_PPC_TM_TAR);
    eval 'sub KVM_REG_PPC_TM_XER () {( &KVM_REG_PPC_TM |  &KVM_REG_SIZE_U64 | 0x6a);}' unless defined(&KVM_REG_PPC_TM_XER);
    eval 'sub KVM_DEV_XICS_GRP_SOURCES () {1;}' unless defined(&KVM_DEV_XICS_GRP_SOURCES);
    eval 'sub KVM_DEV_XICS_GRP_CTRL () {2;}' unless defined(&KVM_DEV_XICS_GRP_CTRL);
    eval 'sub KVM_DEV_XICS_NR_SERVERS () {1;}' unless defined(&KVM_DEV_XICS_NR_SERVERS);
    eval 'sub KVM_XICS_DESTINATION_SHIFT () {0;}' unless defined(&KVM_XICS_DESTINATION_SHIFT);
    eval 'sub KVM_XICS_DESTINATION_MASK () {0xffffffff;}' unless defined(&KVM_XICS_DESTINATION_MASK);
    eval 'sub KVM_XICS_PRIORITY_SHIFT () {32;}' unless defined(&KVM_XICS_PRIORITY_SHIFT);
    eval 'sub KVM_XICS_PRIORITY_MASK () {0xff;}' unless defined(&KVM_XICS_PRIORITY_MASK);
    eval 'sub KVM_XICS_LEVEL_SENSITIVE () {(1 << 40);}' unless defined(&KVM_XICS_LEVEL_SENSITIVE);
    eval 'sub KVM_XICS_MASKED () {(1 << 41);}' unless defined(&KVM_XICS_MASKED);
    eval 'sub KVM_XICS_PENDING () {(1 << 42);}' unless defined(&KVM_XICS_PENDING);
    eval 'sub KVM_XICS_PRESENTED () {(1 << 43);}' unless defined(&KVM_XICS_PRESENTED);
    eval 'sub KVM_XICS_QUEUED () {(1 << 44);}' unless defined(&KVM_XICS_QUEUED);
    eval 'sub KVM_DEV_XIVE_GRP_CTRL () {1;}' unless defined(&KVM_DEV_XIVE_GRP_CTRL);
    eval 'sub KVM_DEV_XIVE_RESET () {1;}' unless defined(&KVM_DEV_XIVE_RESET);
    eval 'sub KVM_DEV_XIVE_EQ_SYNC () {2;}' unless defined(&KVM_DEV_XIVE_EQ_SYNC);
    eval 'sub KVM_DEV_XIVE_NR_SERVERS () {3;}' unless defined(&KVM_DEV_XIVE_NR_SERVERS);
    eval 'sub KVM_DEV_XIVE_GRP_SOURCE () {2;}' unless defined(&KVM_DEV_XIVE_GRP_SOURCE);
    eval 'sub KVM_DEV_XIVE_GRP_SOURCE_CONFIG () {3;}' unless defined(&KVM_DEV_XIVE_GRP_SOURCE_CONFIG);
    eval 'sub KVM_DEV_XIVE_GRP_EQ_CONFIG () {4;}' unless defined(&KVM_DEV_XIVE_GRP_EQ_CONFIG);
    eval 'sub KVM_DEV_XIVE_GRP_SOURCE_SYNC () {5;}' unless defined(&KVM_DEV_XIVE_GRP_SOURCE_SYNC);
    eval 'sub KVM_XIVE_LEVEL_SENSITIVE () {(1 << 0);}' unless defined(&KVM_XIVE_LEVEL_SENSITIVE);
    eval 'sub KVM_XIVE_LEVEL_ASSERTED () {(1 << 1);}' unless defined(&KVM_XIVE_LEVEL_ASSERTED);
    eval 'sub KVM_XIVE_SOURCE_PRIORITY_SHIFT () {0;}' unless defined(&KVM_XIVE_SOURCE_PRIORITY_SHIFT);
    eval 'sub KVM_XIVE_SOURCE_PRIORITY_MASK () {0x7;}' unless defined(&KVM_XIVE_SOURCE_PRIORITY_MASK);
    eval 'sub KVM_XIVE_SOURCE_SERVER_SHIFT () {3;}' unless defined(&KVM_XIVE_SOURCE_SERVER_SHIFT);
    eval 'sub KVM_XIVE_SOURCE_SERVER_MASK () {0xfffffff8;}' unless defined(&KVM_XIVE_SOURCE_SERVER_MASK);
    eval 'sub KVM_XIVE_SOURCE_MASKED_SHIFT () {32;}' unless defined(&KVM_XIVE_SOURCE_MASKED_SHIFT);
    eval 'sub KVM_XIVE_SOURCE_MASKED_MASK () {0x100000000;}' unless defined(&KVM_XIVE_SOURCE_MASKED_MASK);
    eval 'sub KVM_XIVE_SOURCE_EISN_SHIFT () {33;}' unless defined(&KVM_XIVE_SOURCE_EISN_SHIFT);
    eval 'sub KVM_XIVE_SOURCE_EISN_MASK () {0xfffffffe00000000;}' unless defined(&KVM_XIVE_SOURCE_EISN_MASK);
    eval 'sub KVM_XIVE_EQ_PRIORITY_SHIFT () {0;}' unless defined(&KVM_XIVE_EQ_PRIORITY_SHIFT);
    eval 'sub KVM_XIVE_EQ_PRIORITY_MASK () {0x7;}' unless defined(&KVM_XIVE_EQ_PRIORITY_MASK);
    eval 'sub KVM_XIVE_EQ_SERVER_SHIFT () {3;}' unless defined(&KVM_XIVE_EQ_SERVER_SHIFT);
    eval 'sub KVM_XIVE_EQ_SERVER_MASK () {0xfffffff8;}' unless defined(&KVM_XIVE_EQ_SERVER_MASK);
    eval 'sub KVM_XIVE_EQ_ALWAYS_NOTIFY () {0x1;}' unless defined(&KVM_XIVE_EQ_ALWAYS_NOTIFY);
    eval 'sub KVM_XIVE_TIMA_PAGE_OFFSET () {0;}' unless defined(&KVM_XIVE_TIMA_PAGE_OFFSET);
    eval 'sub KVM_XIVE_ESB_PAGE_OFFSET () {4;}' unless defined(&KVM_XIVE_ESB_PAGE_OFFSET);
    eval 'sub KVM_PPC_PVINFO_FLAGS_EV_IDLE () {(1<<0);}' unless defined(&KVM_PPC_PVINFO_FLAGS_EV_IDLE);
    eval 'sub KVM_PPC_PAGE_SIZES_MAX_SZ () {8;}' unless defined(&KVM_PPC_PAGE_SIZES_MAX_SZ);
    eval 'sub KVM_PPC_PAGE_SIZES_REAL () {0x1;}' unless defined(&KVM_PPC_PAGE_SIZES_REAL);
    eval 'sub KVM_PPC_1T_SEGMENTS () {0x2;}' unless defined(&KVM_PPC_1T_SEGMENTS);
    eval 'sub KVM_PPC_NO_HASH () {0x4;}' unless defined(&KVM_PPC_NO_HASH);
}
1;
